# dumps a brush based on number
# Version 2.0 by Zoner
#
# This file is a script, which requires a version of Perl to be installed so it may function.
#
# A Windows version of Perl can be obtained at http://www.activestate.com
#

sub Usage
{
    print STDOUT <<__FOO__
dumpbrush.pl Usage:

perl dumpbrush.pl <entity> <brush> <mapname>

__FOO__
;
    exit 0;
}

sub main
{
    local $entity_to_find = $ARGV[0];
    local $brush_to_find = $ARGV[1];
    local $file = $ARGV[2];

    local $state = -1;
    local $brushnum = -1;
    local $entitynum = -1;

    local $printed_something = 0;

    $file =~ s/\.map//i;

    $_ = $ARGV[0];
    if (($ARGV[0] eq "") || (/(\?|help)/i))
    {
        Usage();
    }

    open(OLD, "<$file.map")         or die "can't open $file: $!";

    while (<OLD>)
    {
        if (/{\s/)
        {
            $state++;
            if ($state == 0)
            {
                $entitynum++;
            }
            elsif ($state == 1)
            {
                $brushnum++;
            }
        }
        if (/}\s/)
        {
            $state--;
            if ($state == -1)
            {
                $brushnum = -1;
            }
        }
        if (($entitynum == $entity_to_find) && ($brushnum == $brush_to_find))
        {
            $printed_something++;
            print $_;
        }
    }

    close(OLD);

    if ($printed_something == 0)
    {
        print "Entity[$entity_to_find] Brush[$brush_to_find] not found in $file\n";
    }
}

&main;
