# Removes unused entity key/value pairs, specifically any already set to their default values.
# Version 2.0 by Zoner
#
# This file is a script, which requires a version of Perl to be installed so it may function.
#
# A Windows version of Perl can be obtained at http://www.activestate.com
#


@srList =
(
    # TFC (mostly)
    '"group_no\" \"0\"\n',
    '"goal_no\" \"0\"\n',
    '"owned_by\" \"0\"\n',
    '"team_no\" \"0\"\n',
    '"axhitme\" \"0\"\n',
    '"wait\" \"0\"\n',
    '"health\" \"0\"\n',
    '"delay_time\" \"0\"\n',
    '"delay\" \"0\"\n',
    '"search_time\" \"0\"\n',
    '"else_goal\" \"0\"\n',
    '"items\" \"0\"\n',
    '"lives\" \"0\"\n',
    '"frags\" \"0\"\n',
    '"count\" \"0\"\n',
    '"style\" \"0\"\n',
    '"skin\" \"0\"\n',
    '"t_length\" \"0\"\n',
    '"(activate|inactivate|remove|restore)_(group|goal)_no\" \"0\"\n',
    '"goal_(activation|effects|result)\" \"0\"\n',
    '"increase_team(1|2|3|4)\" \"0\"\n',
    '"if_(goal|group)_is_(active|inactive|removed)\" \"0\"\n',
    '"maxammo_.*\" \"0\"\n',
    '"ammo_.*\" \"0\"\n',
    '"armor(type|value|class)\" \"0\"\n',
    '"(radsuit|super_damage|invisible|invincible)_finished\" \"0\"\n',
    '"no_grenades_(1|2)\" \"0\"\n',
    '"(remove|restore)_spawn(point|group)\" \"0\"\n',
    '"ha(s|snt)_item_from_group\" \"0\"\n',
    '"display_item_status(1|2|3|4)\" \"0\"\n',
    '"if_item_(has|hasnt)_moved\" \"0\"\n',
    '"remove_item_group\" \"0\"\n',
    '"return_item_no\" \"0\"\n',
    '"items_allowed\" \"0\"\n',
    '"playerclass\" \"0\"\n',

    # Halflife
    '"sounds\" \"0\"\n',
    '"fade(in|out)\" \"0\"\n',
    '"volstart\" \"0\"\n',
    '"spin(up|down)\" \"0\"\n',
    '"cspinup\" \"0\"\n',
    '"lfo(type|rate|modpitch|modvol)\" \"0\"\n',
     
    '"(un|)locked_(sound|sentence)\" \"0\"\n',
    '"lip\" \"0\"\n',
    '"framerate\" \"0\"\n',
    '"damage\" \"0\"\n',
    '"dmg\" \"0\"\n',
    '"framestart\" \"0\"\n',
    '"render(fx|mode|amt)\" \"0\"\n',

    # TFC ents which caused problems 
    # (caused by using really old FGD files)
    # Remove all instances of them
    '"ex_skill_(min|max)\" \"(-1|0|1|2|3|4)\"\n',
);

sub Usage
{
    print <<_FOO__
# stripnulents.pl
# Strips selected entities with values of "0"

# Created with ActiveState's Perl 5.005_03 Build 517
# (www.activestate.com)

# Syntax:
# perl stripnulents.pl <mapname>

# mapname should not include the .map extension
# It will create a .bak of the original map and replace the existing one 
__FOO__
;
    exit 0;
}

sub main 
{
    $file = $ARGV[0];
    $file =~ s/\.map//i;

    $old = "$file.map";
    $new = "$file.tmp.$$";
    $bak = "$file.bak";

    unlink $bak;

    open(OLD, "< $old")         or die "can't open $old: $!";
    open(NEW, "> $new")         or die "can't open $new: $!";

    local $i;
    local $nItems = $#srList + 1;

    while (<OLD>) 
    {
        for ($i=0;$i<$nItems;$i++) 
        {
            s/$srList[$i]//i;
        }
        (print NEW $_)          or die "can't write to $new: $!";
    }

    close(OLD)                  or die "can't close $old: $!";
    close(NEW)                  or die "can't close $new: $!";


    rename($old, $bak)          or die "can't rename $old to $bak: $!";
    rename($new, $old)          or die "can't rename $new to $old: $!";
}

&main;
