# dumps an entity based on line number (typically from 'Line XXXX is incomplete!" messages)
# so that one can find which entity it is and where
#
# Version 2.0 by Zoner
#
# This file is a script, which requires a version of Perl to be installed so it may function.
#
# A Windows version of Perl can be obtained at http://www.activestate.com
#

sub Usage
{
    print STDOUT <<__FOO__
dumpline.pl Usage:

perl dumpline.pl <line> <mapname>

This script will find the entity associated with the line number
request and display it.  This is so that one can find which 
entity is causing 'Line XXXX is incomplete!' errors in a compile.

This script will not dump entity zero, aka 'The Worldspawn' as it
typically has hundreds or thousands of brushes inside it.

__FOO__
;
    exit 0;
}

@EntityData;

sub main
{
    local $line_to_find = $ARGV[0];
    local $file = $ARGV[1];

    local $state = -1;
    local $entitynum = -1;

    local $printed_something = 0;

    $file =~ s/\.map//i;

    $_ = $ARGV[0];
    if (($ARGV[0] eq "") || (/(\?|help)/i))
    {
        Usage();
    }

    if ($line_to_find <= 0)
    {
        Usage();
    }

    open(OLD, "<$file.map")         or die "can't open $file: $!";

    my $currentline = 0;

    while (<OLD>)
    {
        $currentline++;
        if (/{\s/)
        {
            $state++;
            if ($state == 0)
            {
                if ($currentline > $line_to_find)
                {
                    print "\nEntity $entitynum :\n\n";
                    print @EntityData;
                    return;
                }
                undef @EntityData;
                $entitynum++;
            }
        }
        if (/}\s/)
        {
            $state--;  
        }
        push @EntityData, "$currentline> $_";
    }

    close(OLD);

    if ($currentline > $line_to_find)
    {
        print "Map $file only has $currentline lines\n";
    }
}

&main;
